/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.events;

import com.cisco.pt.UUID;
import com.cisco.pt.impl.IPCEventLTV;
import com.cisco.pt.ipc.events.IPCEventRegistry;
import com.cisco.pt.ipc.events.SimulationEvent;
import com.cisco.pt.ipc.events.SimulationEventListener;
import com.cisco.pt.ipc.system.Simulation;
import com.cisco.pt.ptmp.PacketTracerSession;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimulationEventRegistry
extends IPCEventRegistry {
    protected Set<SimulationEventListener> globalListeners = new HashSet<SimulationEventListener>();
    protected Map<String, Set<SimulationEventListener>> specificObjectListeners = new HashMap<String, Set<SimulationEventListener>>();
    private static Log logger = LogFactory.getLog(SimulationEventRegistry.class);

    public SimulationEventRegistry(PacketTracerSession session) {
        super(session);
    }

    @Override
    public String getClassName() {
        return "Simulation";
    }

    @Override
    public void processEvent(IPCEventLTV event) throws Exception {
        String eventName = event.getEventName();
        SimulationEvent evt = null;
        if (eventName.equalsIgnoreCase("forwardStarted")) {
            evt = new SimulationEvent.ForwardStarted(event);
        } else if (eventName.equalsIgnoreCase("forwardEnded")) {
            evt = new SimulationEvent.ForwardEnded(event);
        } else if (eventName.equalsIgnoreCase("newFrameInstanceAdded")) {
            evt = new SimulationEvent.NewFrameInstanceAdded(event);
        } else if (eventName.equalsIgnoreCase("simulationReset")) {
            evt = new SimulationEvent.SimulationReset(event);
        } else if (eventName.equalsIgnoreCase("simulationModeChanged")) {
            evt = new SimulationEvent.SimulationModeChanged(event);
        } else {
            logger.info((Object)("Unrecognized eventName for " + this.getClassName() + ": " + eventName));
            return;
        }
        for (SimulationEventListener listener : this.globalListeners) {
            listener.handleEvent(evt);
        }
        Set<SimulationEventListener> specificListeners = this.specificObjectListeners.get(evt.objectUUID.toString());
        if (specificListeners != null) {
            for (SimulationEventListener listener : specificListeners) {
                listener.handleEvent(evt);
            }
        }
    }

    public void addListenerFiltered(SimulationEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (events == null) {
                this.register("forwardStarted");
                this.register("forwardEnded");
                this.register("newFrameInstanceAdded");
                this.register("simulationReset");
                this.register("simulationModeChanged");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(events.get(i));
                }
            }
        }
        this.globalListeners.add(listener);
    }

    public void addSpecificListenerFiltered(SimulationEventListener listener, Simulation objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<SimulationEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners == null) {
            specificListeners = new HashSet<SimulationEventListener>();
            this.specificObjectListeners.put(uuidString, specificListeners);
            if (events == null) {
                this.register(uuid, "forwardStarted");
                this.register(uuid, "forwardEnded");
                this.register(uuid, "newFrameInstanceAdded");
                this.register(uuid, "simulationReset");
                this.register(uuid, "simulationModeChanged");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(uuid, events.get(i));
                }
            }
        }
        specificListeners.add(listener);
    }

    public void removeListenerFiltered(SimulationEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() != 0) {
            if (events == null) {
                this.deregister("forwardStarted");
                this.deregister("forwardEnded");
                this.deregister("newFrameInstanceAdded");
                this.deregister("simulationReset");
                this.deregister("simulationModeChanged");
            }
            this.globalListeners.remove(listener);
        }
    }

    public void removeSpecificListenerFiltered(SimulationEventListener listener, Simulation objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<SimulationEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners != null && !specificListeners.isEmpty()) {
            this.deregister(uuid, "forwardStarted");
            this.deregister(uuid, "forwardEnded");
            this.deregister(uuid, "newFrameInstanceAdded");
            this.deregister(uuid, "simulationReset");
            this.deregister(uuid, "simulationModeChanged");
            specificListeners.remove(listener);
        }
    }

    public void addListener(SimulationEventListener listener) throws IOException {
        this.addListenerFiltered(listener, null);
    }

    public void addListener(SimulationEventListener listener, Simulation objClass) throws IOException {
        this.addSpecificListenerFiltered(listener, objClass, null);
    }

    public void removeListener(SimulationEventListener listener) throws IOException {
        this.removeListenerFiltered(listener, null);
    }

    public void removeListener(SimulationEventListener listener, Simulation objClass) throws IOException {
        this.removeSpecificListenerFiltered(listener, objClass, null);
    }
}

